/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.cmdterm;

import com.quantumdata.std.IQDPluginContext;
import com.quantumdata.std.InstrumentException;
import com.quantumdata.std.InstrumentResponse;
import com.quantumdata.std.RemoteInstrument;
import com.quantumdata.widgets.QDButton;
import com.quantumdata.widgets.QDComboBox;
import com.quantumdata.widgets.QDLabel;
import com.quantumdata.widgets.QDPanel;
import com.quantumdata.widgets.QDStdUI;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class QDCmdLine
extends JPanel {
    private static final long serialVersionUID = 1L;
    private QDComboBox m_request;
    private QDLabel m_statusLine;
    private QDButton m_reconnect;
    private JTextArea m_text;
    private final int MAX_COUNT = 20;
    private RemoteInstrument m_instrument = null;
    private IQDPluginContext m_context;

    public QDCmdLine(IQDPluginContext iQDPluginContext) {
        this.m_context = iQDPluginContext;
        this.initComponents();
    }

    private void initComponents() {
        this.m_request = new QDComboBox();
        this.m_statusLine = new QDLabel();
        this.m_text = new JTextArea();
        this.setLayout(new BorderLayout());
        this.m_request.setEditable(true);
        this.m_request.getEditor().setItem("<enter a CMD here>");
        this.m_request.getEditor().selectAll();
        this.m_request.setEnabled(false);
        JTextField jTextField = (JTextField)this.m_request.getEditor().getEditorComponent();
        jTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QDCmdLine.this.RequestEntry(actionEvent);
            }
        });
        this.add((Component)this.m_request, "North");
        QDPanel qDPanel = new QDPanel(new BorderLayout());
        this.m_reconnect = new QDButton("Reconnect");
        this.m_reconnect.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                QDCmdLine.this.reconnect();
            }
        });
        qDPanel.add((Component)this.m_reconnect, "West");
        this.m_statusLine.setText("   ");
        qDPanel.add((Component)this.m_statusLine, "Center");
        this.add((Component)qDPanel, "South");
        JScrollPane jScrollPane = new JScrollPane();
        this.m_text.setCaretColor(QDStdUI.getActionForeground());
        this.m_text.setSelectionColor(QDStdUI.getSelectedColor());
        this.m_text.setBackground(Color.black);
        this.m_text.setForeground(QDStdUI.getSelectedColor());
        this.m_text.setColumns(50);
        this.m_text.setEditable(false);
        this.m_text.setRows(20);
        this.m_text.setTabSize(2);
        jScrollPane.setViewportView(this.m_text);
        this.add((Component)jScrollPane, "Center");
    }

    private void RequestEntry(ActionEvent actionEvent) {
        String string = (String)this.m_request.getEditor().getItem();
        this.m_text.append(string + "\r\n");
        InstrumentResponse instrumentResponse = this.m_instrument.sendCmd(string);
        this.m_text.append(instrumentResponse.getResponse() + "\r\n--> ");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
        if (this.m_request.getItemCount() == 20) {
            this.m_request.removeItemAt(0);
        }
        this.m_request.addItem(string);
        this.m_request.setSelectedIndex(this.m_request.getItemCount() - 1);
        this.m_request.getEditor().selectAll();
    }

    private void reconnect() {
        if (this.m_instrument == null) {
            return;
        }
        String string = "";
        this.m_instrument.disconnect();
        try {
            this.m_instrument.connect();
            string = "Connected";
            this.m_request.setEnabled(true);
        }
        catch (InstrumentException instrumentException) {
            this.m_request.addItem("*** Unable to reconnect\r\n");
            string = instrumentException.getMessage();
            this.m_request.setEnabled(false);
        }
        this.m_text.append(string + "\r\n--> ");
        this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
        this.m_request.getEditor().selectAll();
    }

    public RemoteInstrument getInstrument() {
        return this.m_instrument;
    }

    public void setInstrument(RemoteInstrument remoteInstrument) {
        this.m_instrument = remoteInstrument;
        if (this.m_instrument == null) {
            this.m_request.setEnabled(false);
            this.m_reconnect.setEnabled(false);
        } else {
            this.m_reconnect.setEnabled(true);
            if (!remoteInstrument.isConnected()) {
                this.reconnect();
            } else {
                this.m_request.setEnabled(true);
                this.m_text.append("\r\n--> ");
                this.m_text.setCaretPosition(this.m_text.getText().length() - 1);
                this.m_request.getEditor().selectAll();
            }
        }
    }

    public void showReconnect(boolean bl) {
        this.m_reconnect.setVisible(bl);
    }

    public boolean close() {
        return true;
    }

    public void start() {
        this.m_instrument = this.m_context.getConnectionManager().getDefaultInstrument();
        if (this.m_instrument != null && this.m_instrument.isConnected()) {
            this.m_request.setEnabled(true);
        }
        this.m_request.getEditor().selectAll();
        this.m_text.setText("--> ");
    }

    public void selectCmdLine() {
        this.m_request.getEditor().selectAll();
    }
}

